//
//  RedViewController.swift
//  TabControllerDemo
//
//  Created by Sakib Miazi on 6/6/23.
//

import UIKit

class RedViewController: UIViewController {
    let redView = RedView()
    
    let notificationCenter = NotificationCenter.default
    
    override func loadView() {
        view = redView
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = .white
        title = "Red"
        
        //MARK: setting observers...
        observeBlue()
        observeGreen()

        //MARK: send hello button...
        redView.buttonSend.addTarget(self, action: #selector(onButtonSendTapped), for: .touchUpInside)
    }
    
    //MARK: observing blue...
    func observeBlue(){
        notificationCenter.addObserver(
            self,
            selector: #selector(notificationReceived(notification:)),
            name: .fromBlue, object: nil
        )
    }
    
    //MARK: observing green...
    func observeGreen(){
        notificationCenter.addObserver(
            self,
            selector: #selector(notificationReceived(notification:)),
            name: .fromGreen, object: nil
        )
    }
    
    //MARK: handling notifications...
    @objc func notificationReceived(notification: Notification){
        redView.labelReceived.text = notification.object as! String
    }
    
    //MARK: sending hello to other screens...
    @objc func onButtonSendTapped(){
        notificationCenter.post(
            name: .fromRed,
            object: "Hello from Red!"
        )
    }

}
